% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funs.overall.seg}
\alias{funs.overall.seg}
\alias{overall.seg.ct}
\alias{overall.seg}
\title{Overall Segregation Tests for NNCTs}
\usage{
overall.seg.ct(ct, covN, type)

overall.seg(dat, lab, type, ...)
}
\arguments{
\item{ct}{A nearest neighbor contingency table, used in \code{overall.seg.ct} only}

\item{covN}{The \eqn{k^2 \times k^2} covariance matrix of row-wise vectorized entries of NNCT, \code{ct};
used in \code{overall.seg.ct} only.}

\item{type}{The type of the overall test with no default.
Takes on values \code{"dixon"} or \code{"nnct"} for Dixon's overall test and \code{"I"}-\code{"IV"} for types I-IV cell-specific
test (or equivalently \code{1-6}, respectively).}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{overall.seg} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{overall.seg} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.
used in \code{overall.seg} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The overall chi-squared statistic for the specified type}
\item{stat.names}{Name of the test statistic}
\item{p.value}{The \eqn{p}-value for the hypothesis test}
\item{df}{Degrees of freedom for the chi-squared test, which is \eqn{k(k-1)} for type II and Dixon's tests
and \eqn{(k-1)^2} for others.}
\item{estimate}{Estimates of the parameters, NNCT for Dixon's test and type I-IV TCT for others.}
\item{est.name,est.name2}{Names of the estimates, former is a longer description of the estimates
than the latter.}
\item{null.value}{Matrix of hypothesized null values for the parameters which are expected values of the
the \eqn{N_{ij}} values in the NNCT or \eqn{T_{ij}} values in the TCT.}
\item{null.name}{Name of the null values}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{ct}, returned by \code{overall.seg.ct} only}
\item{data.name}{Name of the data set, \code{dat}, returned by \code{overall.seg} only}
}
\description{
Two functions: \code{overall.seg.ct} and \code{overall.seg}.

All functions are objects of class \code{"Chisqtest"} but with different arguments (see the parameter list below).
Each one performs hypothesis tests of deviations of 
cell counts from the expected values under RL or CSR for all cells (i.e., entries) combined in the NNCT or TCT.
That is, each test is one of Dixon's or Types I-IV overall test of segregation based on NNCTs or TCTs
for \eqn{k \ge 2} classes.
Each overall test is based on the chi-squared approximation of the corresponding quadratic form
and are due to \insertCite{dixon:1994,dixon:NNCTEco2002;textual}{nnspat}
and to \insertCite{ceyhan:SJScorrected2010,ceyhan:jkss-posthoc-2017;textual}{nnspat}, respectively.
All functions exclude some row and/or column of the TCT, to avoid ill-conditioning of the covariance matrix
of the NNCT (for its inversion in the quadratic form), see the relevant functions under See also section below.

The \code{type="dixon"} or \code{"nnct"} refers to Dixon's overall test of segregation, and
\code{type="I"}-\code{"IV"} refers to types I-IV overall tests, respectively.

Each function yields the test statistic, \eqn{p}-value and \code{df} which is \eqn{k(k-1)} for type II and Dixon's test 
and \eqn{(k-1)^2} for the other types, description of the 
alternative with the corresponding null values (i.e., expected values) of TCT entries, sample estimates (i.e., observed values) of the entries in TCT.
The functions also provide names of the test statistics, the description of the test and the data set used.

The null hypothesis is that all \eqn{N_{ij}} or \eqn{T_{ij}} entries for the specified type are equal to their expected values
under RL or CSR, respectively.

See also
(\insertCite{dixon:1994,dixon:NNCTEco2002,ceyhan:eest-2010,ceyhan:SJScorrected2010,ceyhan:jkss-posthoc-2017;textual}{nnspat})
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv) #default is byrow

type<-"dixon" #try also "nnct", I", "II", "III", and "IV"
overall.seg(Y,cls,type)
overall.seg(Y,cls,type,method="max")
overall.seg(Y,cls,type="I")

overall.seg.ct(ct,covN,type)
overall.seg.ct(ct,covN,type="I")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

overall.seg(Y,fcls,type="I")
overall.seg.ct(ct,covN,type)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

overall.seg(Y,cls,type="I")
overall.seg.ct(ct,covN,type)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{overall.nnct.ct}}, \code{\link{overall.nnct}}, \code{\link{overall.tct.ct}}
and \code{\link{overall.tct}}
}
\author{
Elvan Ceyhan
}
