% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R
\name{dbListTables}
\alias{dbListTables}
\alias{dbListTables,AthenaConnection-method}
\title{List Athena Tables}
\usage{
\S4method{dbListTables}{AthenaConnection}(conn, catalog = NULL, schema = NULL, ...)
}
\arguments{
\item{conn}{A \link[DBI:DBIConnection-class]{DBI::DBIConnection} object,
as returned by \link[DBI:dbConnect]{dbConnect()}.}

\item{catalog}{Athena catalog, default set to NULL to return all tables from all Athena catalogs}

\item{schema}{Athena schema, default set to NULL to return all tables from all Athena schemas.
Note: The use of DATABASE and SCHEMA is interchangeable within Athena.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbListTables()} returns a character vector with all the tables from Athena.
}
\description{
Returns the unquoted names of Athena tables accessible through this connection.
}
\examples{
\dontrun{
# Note:
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `noctua::dbConnect` documnentation

library(DBI)

# Demo connection to Athena using profile name
con <- dbConnect(noctua::athena())

# Return list of tables in Athena
dbListTables(con)

# Disconnect conenction
dbDisconnect(con)
}
}
\seealso{
\code{\link[DBI]{dbListTables}}
}
