% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adverbial.R
\name{adverbial}
\alias{adverbial}
\alias{nom_adv}
\alias{nom_times}
\title{Convert numbers to adverbial character vectors (once, twice, three times)}
\usage{
adverbial(x, thrice = FALSE, ...)

nom_adv(x, thrice = FALSE, ...)

nom_times(x, thrice = FALSE, ...)
}
\arguments{
\item{x}{A numeric vector}

\item{thrice}{A logical of length one.
If \code{TRUE}, the adverbial of \code{3} will be "thrice".
If \code{FALSE}, the adverbial of \code{3} will be "three times".
Defaults to \code{FALSE}.}

\item{...}{Additional arguments passed to \code{\link[=cardinal]{cardinal()}}}
}
\value{
A character vector of the same length as \code{x}
}
\description{
Convert numbers to adverbial character vectors (once, twice, three times)
}
\examples{
nom_adv(1:4)
nom_adv(1:4, thrice = TRUE)
}
\seealso{
Other number names: 
\code{\link{cardinal}()},
\code{\link{collective}()},
\code{\link{denominator}()},
\code{\link{numerator}()},
\code{\link{ordinal}()},
\code{\link{ratio}()}
}
\concept{number names}
