% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centered_barplot.R
\name{centered_barplot}
\alias{centered_barplot}
\title{Centered Frequency Bar Plot for Nominal Variables
Creates a centered bar plot for discrete nominal variables by placing the
most frequent category at the center and progressively less frequent
categories alternately to the left and right.}
\usage{
centered_barplot(df, var, title = NULL, scale = c("count", "percent"))
}
\arguments{
\item{df}{A data frame containing the nominal variable.}

\item{var}{A character string giving the name of the nominal variable in \code{df}.}

\item{title}{Optional character string specifying the plot title.}

\item{scale}{Character string specifying the scale of the frequencies:
\code{"count"} (default) for raw counts or \code{"percent"} for percentages.}
}
\value{
A \code{ggplot2} object.
}
\description{
Centered Frequency Bar Plot for Nominal Variables
Creates a centered bar plot for discrete nominal variables by placing the
most frequent category at the center and progressively less frequent
categories alternately to the left and right.
}
\examples{
centered_barplot(categories, "animal")
centered_barplot(categories, "animal", scale = "percent")

}
