#' udf.R: Utility for User data functions (UDF) operations in Fabric
#' @noRd
.dummyStr <- ""
 
#' Run a User data functions (UDF).
#'
#' @param artifactId The UDF artifact id.
#' @param functionName The UDF function name.
#' @param parameters The UDF parameters.
#' @param workspaceId The UDF workspace id, if not provided, it will be retrieved from the current workspace.
#' @param capacityId The UDF capacity id, if not provided, it will be retrieved from the current capacity.
#' @return The UDF execution result.
#' @export
notebookutils.udf.run <- function(artifactId, functionName, parameters = list(), workspaceId = "", capacityId = "") {
  NULL
}

#' Get UDF functions metadata.
#'
#' Dummy implementation for local development.
#'
#' @param udf UDF artifact id or name
#' @param workspaceId Workspace id
#' @return A dummy UDF object (list)
#' @export
notebookutils.udf.getFunctions <- function(udf, workspaceId = "") {
  NULL
}

#' Get help string for a method.
#'
#' @param funcName function name
#' @param namespace namespace
#' @export
notebookutils.udf.getHelpString <- function(funcName = "", namespace = "") {
  .dummyStr
}

#' Get help string for a method.
#'
#' @param methodName Name of the method
#' @export
notebookutils.udf.help <- function(methodName = "") {
  .dummyStr
}
