% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{DatabasesEndpoint}
\alias{DatabasesEndpoint}
\title{R6 Class for Databases Endpoint}
\value{
A list containing the parsed API response.
}
\description{
Handle all databases operations in the Notion API

\strong{Note:} Access this endpoint through the client instance, e.g., \code{notion$databases}. Not to be instantiated directly.
}
\examples{
\dontshow{if (notion_token_exists()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
notion <- notion_client()

# ----- create a database
\dontshow{notionapi::vcr_example_start("notion-databases-create")}
notion$databases$create(
  parent = list(page_id = "23933ea0-c1e4-81d6-a6f6-dd5b57ad4aba"),
  title = list(
    list(
      type = "text",
      text = list(
        content = "Grocery list"
      )
    )
  ),
  properties = list(
    Name = list(
      title = no_config()
    ),
    `In stock` = list(
      checkbox = no_config()
    )
  )
)
\dontshow{notionapi::vcr_example_end()}

# ----- retrieve a database
\dontshow{notionapi::vcr_example_start("notion-databases-retrieve")}
notion$databases$retrieve(
  "23933ea0-c1e4-8136-b37b-fa235c6f2a71"
)
\dontshow{notionapi::vcr_example_end()}

# ----- update a database
\dontshow{notionapi::vcr_example_start("notion-database-update")}
notion$databases$update(
  "23933ea0-c1e4-8136-b37b-fa235c6f2a71",
  list(list(
    text = list(
      content = "Today's grocery list"
    )
  ))
)
\dontshow{notionapi::vcr_example_end()}

# ----- query a database
\dontshow{notionapi::vcr_example_start("notion-database-query")}
notion$databases$query(
  database_id = "23933ea0-c1e4-8136-b37b-fa235c6f2a71",
  filter = list(
    or = list(
      list(
        property = "In stock",
        checkbox = list(equals = TRUE)
      ),
      list(
        property = "Name",
        title = list(contains = "kale")
      )
    )
  ),
  sorts = list(list(
    property = "Name",
    direction = "ascending"
  ))
)
\dontshow{notionapi::vcr_example_end()}

# ----- iterate through paginated results
\dontrun{
i <- 1
resps <- list()
has_more <- FALSE
start_cursor <- NULL

while (has_more) {
  resps[[i]] <- notion$databases$query(
    "22833ea0c1e481178e9cf1dcba79dbca",
    start_cursor = start_cursor
  )

  has_more <- resps[[i]][["has_more"]]
  start_cursor <- resps[[i]][["next_cursor"]]
  i <- i + 1
}
}
\dontshow{\}) # examplesIf}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DatabasesEndpoint-new}{\code{DatabasesEndpoint$new()}}
\item \href{#method-DatabasesEndpoint-create}{\code{DatabasesEndpoint$create()}}
\item \href{#method-DatabasesEndpoint-query}{\code{DatabasesEndpoint$query()}}
\item \href{#method-DatabasesEndpoint-retrieve}{\code{DatabasesEndpoint$retrieve()}}
\item \href{#method-DatabasesEndpoint-update}{\code{DatabasesEndpoint$update()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DatabasesEndpoint-new"></a>}}
\if{latex}{\out{\hypertarget{method-DatabasesEndpoint-new}{}}}
\subsection{Method \code{new()}}{
Initialise databases endpoint.
Not to be called directly, e.g., use \code{notion$databases} instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatabasesEndpoint$new(client)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{client}}{Notion Client instance}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DatabasesEndpoint-create"></a>}}
\if{latex}{\out{\hypertarget{method-DatabasesEndpoint-create}{}}}
\subsection{Method \code{create()}}{
Create a database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatabasesEndpoint$create(parent, title, properties, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parent}}{Named list (JSON object) (required). The parent page where the database will be created.}

\item{\code{title}}{List of lists (JSON array). Database title as an array of \href{https://developers.notion.com/reference/rich-text}{rich text objects}.}

\item{\code{properties}}{Named list (JSON object) (required). The properties of the database as key-value pairs.}

\item{\code{...}}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Additional body parameters to include in the request body.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\href{https://developers.notion.com/reference/create-a-database}{Endpoint documentation}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DatabasesEndpoint-query"></a>}}
\if{latex}{\out{\hypertarget{method-DatabasesEndpoint-query}{}}}
\subsection{Method \code{query()}}{
Query a database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatabasesEndpoint$query(
  database_id,
  filter_properties = NULL,
  filter = NULL,
  sorts = NULL,
  start_cursor = NULL,
  page_size = 100,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{database_id}}{String (required). The ID of a Notion database.}

\item{\code{filter_properties}}{Character vector. Property value IDs to include in the response schema.}

\item{\code{filter}}{Named list (JSON object). \href{https://developers.notion.com/reference/post-database-query-filter}{Filter conditions}
to apply to the query.}

\item{\code{sorts}}{List of lists (JSON array). \href{https://developers.notion.com/reference/post-database-query-sort}{Sort conditions}
to apply to the query.}

\item{\code{start_cursor}}{Character. For pagination. If provided, returns results starting from this cursor.
If NULL, returns the first page of results.}

\item{\code{page_size}}{Integer. Number of items to return per page (1-100). Defaults to 100.}

\item{\code{...}}{Reserved for future use.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\href{https://developers.notion.com/reference/post-database-query}{Endpoint documentation}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DatabasesEndpoint-retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-DatabasesEndpoint-retrieve}{}}}
\subsection{Method \code{retrieve()}}{
Retrieve a database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatabasesEndpoint$retrieve(database_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{database_id}}{String (required). The ID of a Notion database.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\href{https://developers.notion.com/reference/retrieve-a-database}{Endpoint documentation}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DatabasesEndpoint-update"></a>}}
\if{latex}{\out{\hypertarget{method-DatabasesEndpoint-update}{}}}
\subsection{Method \code{update()}}{
Update a database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatabasesEndpoint$update(
  database_id,
  title = NULL,
  description = NULL,
  properties = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{database_id}}{String (required). The ID of a Notion database.}

\item{\code{title}}{List of lists (JSON array). Database title as an array of rich text objects.}

\item{\code{description}}{List of lists (JSON array). Database description as an array of rich text objects.}

\item{\code{properties}}{Named list (JSON object). Database properties to update as key-value pairs.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\href{https://developers.notion.com/reference/update-a-database}{Endpoint documentation}
}

}
}
