% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hettmansperger_McKean.r
\name{Hettmansperger_McKean}
\alias{Hettmansperger_McKean}
\title{Hettmansperger and McKean Method for ANCOVA}
\usage{
Hettmansperger_McKean(data, formula)
}
\arguments{
\item{data}{A data frame containing the variables specified in the formula.}

\item{formula}{An object of class "formula": a symbolic description of the 
model to be fitted. The structure should be `response ~ covariate1 + ... + group`.}
}
\value{
A list containing the following components:
\describe{
  \item{regression_equation_covariate}{The summary of the initial model fitting response on covariates.}
  \item{regression_equation_residuals}{The summary of the model fitting weighted ranked residuals on the group.}
  \item{anova}{The ANOVA table for the model based on weighted ranked residuals.}
  \item{group_means}{A data frame of the mean of weighted ranked residuals for each group.}
  \item{group_sds}{A data frame of the standard deviation of weighted ranked residuals for each group.}
  \item{data}{The original data frame augmented with residuals, ranked residuals, and weighted ranked residuals.}
}
}
\description{
Applies rank-based residual analysis for ANCOVA. This method involves
fitting a model of the response on the covariate, calculating residuals,
ranking them, and then performing an ANOVA on the (weighted) ranked residuals.
}
\examples{
# 1. Create a sample data frame
data <- data.frame(
  group = c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3),
  response = c(16, 60, 82, 126, 137, 44, 67, 87, 100, 142, 17, 28, 105, 149, 160),
  covariate1 = c(26, 10, 42, 49, 55, 21, 28, 5, 12, 58, 1, 19, 41, 48, 35),
  covariate2 = c(12, 21, 24, 29, 34, 17, 2, 40, 38, 36, 8, 1, 9, 28, 16)
)

# 2. Run the Hettmansperger and McKean method
results <- Hettmansperger_McKean(
  formula = response ~ covariate1 + covariate2 + group,
  data = data
)

# 3. View the results
print(results)
print(results$anova)

}
\references{
Hettmansperger TP, McKean JWJT. A robust alternative based on ranks to least squares in analyzing linear models. 1977;19(3):275-84.

Hettmansperger TP, McKean JWJJotASA. A geometric interpretation of inferences based on ranks in the linear model. 1983;78(384):885-93.
}
