% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_filter.R
\name{nest_filter}
\alias{nest_filter}
\title{Subset rows in nested data frames using column values.}
\usage{
nest_filter(.data, .nest_data, ..., .preserve = FALSE)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g., a tibble), or a lazy
data frame (e.g., from dbplyr or dtplyr).}

\item{.nest_data}{A list-column containing data frames}

\item{...}{Expressions that return a logical value, and are defined in terms
of the variables in \code{.nest_data}. If multiple expressions are included,
they are combined with the \code{&} operator. Only rows for which all conditions
evaluate to \code{TRUE} are kept.}

\item{.preserve}{Relevant when \code{.nest_data} is grouped. If
\code{.preserve = FALSE} (the default), the grouping structure is recalculated
based on the resulting data, otherwise the grouping is kept as is.}
}
\value{
An object of the same type as \code{.data}. Each object in the column \code{.nest_data}
will also be of the same type as the input. Each object in \code{.nest_data} has
the following properties:
\itemize{
\item Rows are a subset of the input, but appear in the same order.
\item Columns are not modified.
\item The number of groups may be reduced (if \code{.preserve} is not \code{TRUE}).
\item Data frame attributes are preserved.
}
}
\description{
\code{nest_filter()} is used to subset nested data frames, retaining all rows that
satisfy your conditions. To be retained, the row must produce a value of
\code{TRUE} for all conditions. Note that when a condition evaluates to \code{NA} the
row will be dropped, unlike base subsetting with \code{[}.

\code{nest_filter()} subsets the rows within \code{.nest_data}, applying the
expressions in \code{...} to the column values to determine which rows should be
retained. It can be applied to both grouped and ungrouped data.
}
\details{
\code{nest_filter()} is largely a wrapper for \code{\link[dplyr:filter]{dplyr::filter()}} and maintains the
functionality of \code{filter()} within each nested data frame. For more
information on \code{filter()}, please refer to the documentation in
\href{https://dplyr.tidyverse.org/}{\code{dplyr}}.
}
\examples{
gm_nest <- gapminder::gapminder \%>\% tidyr::nest(country_data = -continent)

# apply a filter
gm_nest \%>\%
  nest_filter(country_data, year > 1972)

# apply multiple filters
gm_nest \%>\%
  nest_filter(country_data, year > 1972, pop < 10000000)
  
# apply a filter on grouped data
gm_nest \%>\%
  nest_group_by(country_data, country) \%>\%
  nest_filter(country_data, pop > mean(pop))
}
\seealso{
Other single table verbs: 
\code{\link{nest_arrange}()},
\code{\link{nest_mutate}()},
\code{\link{nest_rename}()},
\code{\link{nest_select}()},
\code{\link{nest_slice}()},
\code{\link{nest_summarise}()}
}
\concept{single table verbs}
