% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_spherical_to_cartesian.R
\name{convert_spherical_to_cartesian}
\alias{convert_spherical_to_cartesian}
\title{Converts Spherical to Cartesian Coordinates.}
\usage{
convert_spherical_to_cartesian(spherical_coords)
}
\arguments{
\item{spherical_coords}{A matrix of rows containing the longitude and
latitude, measured in radians, of specific points on a 3-dimensional sphere.}
}
\value{
A matrix whose rows contain the Cartesian coordinates
of the specified points.
}
\description{
The longitude and latitude coordinates of points on a 3-dimensional
sphere with unit radius and center at the origin
are converted to the
equivalent Cartesian coordinates.
}
\examples{
library(nprotreg)

# Define the Spherical coordinates of the North and South Poles.

north_pole <- cbind(0, pi / 2)
south_pole <- cbind(0, - pi / 2)
spherical_coords <- rbind(north_pole, south_pole)

# Get the corresponding Cartesian coordinates.

cartesian_coords <- convert_spherical_to_cartesian(spherical_coords)
}
\seealso{
\url{http://mathworld.wolfram.com/SphericalCoordinates.html}.

Other Conversion functions: 
\code{\link{convert_cartesian_to_spherical}()}
}
\concept{Conversion functions}
