% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsarfima.R
\name{mle.arfima}
\alias{mle.arfima}
\title{Pseudo-Maximum Likelihood Estimation of ARFIMA Model}
\usage{
mle.arfima(
  y,
  p = 1,
  q = 0,
  d.range = c(0, 1),
  start,
  incl.mean = TRUE,
  verbose = FALSE,
  method = c("Nelder-Mead", "BFGS", "CG", "L-BFGS-B", "SANN", "Brent"),
  control = list()
)
}
\arguments{
\item{y}{Numeric vector of the time series.}

\item{p}{Autoregressive order.}

\item{q}{Moving average order.}

\item{d.range}{Range of allowable values for fractional differencing parameter. Smallest value must be greater than -1.}

\item{start}{Named vector of length 1 + \code{p} + \code{q} containing initial fit values for the fractional differencing parameter, the AR parameters, and the MA parameters (\emph{e.g.} \code{start = c(d=0.4, ar.1=-0.4, ma.1=0.3, ma.2=0.4)}). If missing, automatically selected.}

\item{incl.mean}{Whether or not to include a mean term in the model. The default value of \code{TRUE} is recommended unless the true mean is known and previously subtracted. Mean is returned with standard error, which may be misleading for \code{d>=0.5}.}

\item{verbose}{Whether to print summary of fit.}

\item{method}{Method for \code{\link[stats]{optim}}, see \code{help(optim)}.}

\item{control}{List of additional arguments for \code{\link[stats]{optim}}, see \code{help(optim)}.}
}
\value{
A list containing:\tabular{ll}{
\code{pars}\tab A numeric vector of parameter estimates.\cr
\tab \cr
\code{std.errs} \tab A numeric vector of standard errors on parameters.\cr
\tab \cr
\code{cov.mat} \tab Parameter covariance matrix (excluding mean).\cr
\tab \cr
\code{fit.obj} \tab \code{\link[stats]{optim}} fit object.\cr
\tab \cr
\code{p.val} \tab Ljung-Box \emph{p}-value for fit.\cr
\tab \cr
\code{residuals} \tab Fit residuals.\cr
}
}
\description{
Fits an ARFIMA(\emph{p},\emph{d},\emph{q}) model to a time series using a pseudo-maximum likelihood estimator. For details see Beran (1995).
}
\examples{
set.seed(1)
x <- arfima.sim(1000, d=0.6, ar=c(-0.4))
fit <- mle.arfima(x, p=1, incl.mean=FALSE, verbose=TRUE) 

## Fit Summary
## --------------------
## Ljung-Box p-val:  0.263 
##        sig2       d     ar.1
## est 1.09351 0.53933 -0.37582
## err 0.05343 0.04442  0.05538
##
## Correlation Matrix for ARFIMA Parameters
##         sig2       d    ar.1
## sig2  1.0000 -0.3349  0.4027
## d    -0.3349  1.0000 -0.8318
## ar.1  0.4027 -0.8318  1.0000
}
\references{
Beran, J. (1995). Maximum Likelihood Estimation of the Differencing Parameter for Short and Long Memory Autoregressive Integrated Moving Average Models. \emph{Journal of the Royal Statistical Society. Series B (Methodological)}, \strong{57}, No. 4, 659-672. doi: \href{https://doi.org/10.1111/j.2517-6161.1995.tb02054.x}{10.1111/j.2517-6161.1995.tb02054.x}
}
\seealso{
\code{\link{mde.arfima}} for minimum distance estimation.
}
