% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var.pf.R
\name{var}
\alias{var}
\alias{var.pf}
\title{Variance method for objects of class pf}
\usage{
var(x, ...)

\method{var}{pf}(x, by_locus = FALSE, ...)
}
\arguments{
\item{x}{Object of class \code{pf}: output of \link{pr_total_number_of_distinct_alleles}}

\item{...}{other arguments that may p}

\item{by_locus}{If \code{TRUE} then the results will be returned locus by locus}
}
\value{
Either a vector of variances, one for each locus, or the sum of the locus variances.
The variances are the variances of the number of alleles observed at each locus.
}
\description{
Variance method for objects of class pf

Variance method for \code{pf} object
}
\examples{
freqs <- read_allele_freqs(system.file("extdata","FBI_extended_Cauc.csv",
                           package = "numberofalleles"))
p <- pr_total_number_of_distinct_alleles(contributors = c("U1","U2"),
                                         freqs = freqs)
mean(p)
var(p)

}
\seealso{
\link{mean.pf}
}
