library(testthat)
library(numspellR)

test_that("numspellr works on numeric vector wrapped in data frame", {
  df <- data.frame(x = c(1, 1, 1, 2, 2, 2, 2))
  res <- numspellr(df, lang = "english")

  expect_true(is.data.frame(res))
  expect_true("avg_spell" %in% names(res))
  expect_true(is.numeric(res$avg_spell))
})
