% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithms.R
\name{Chan_update}
\alias{Chan_update}
\title{Processing a new data point for the 'Chan' class}
\usage{
Chan_update(x_new, X_recent, CUSUM, p0, w, lambda)
}
\arguments{
\item{x_new}{a new data point}

\item{X_recent}{matrix of \code{w} most recent observations}

\item{CUSUM}{tail partial sums of different lengths to be tracked online}

\item{p0}{sparsity parameter}

\item{w}{window parameter}

\item{lambda}{a tuning parameter for the 'Chan' method}
}
\value{
a list of
\itemize{
\item stat: test statistic for the 'Chan' class.
\item X_recent: the updated X_recent matrix
\item CUSUM: the updated CUSUM matrix
}
}
\description{
This function implements the \code{\link{getData}} function to
perform the online changepoint detection for the 'Chan' class.
}
\references{
Chan, H. P. (2017) Optimal sequential detection in multi-stream data.
\emph{Ann. Statist.}, \strong{45}, 2736--2763.
}
