% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percentileBootFunctions.R
\name{percci}
\alias{percci}
\alias{percpval}
\title{Percentile Bootstrap Two-sided Confidence Intervals and p-values}
\usage{
percci(Ti, conf.level = 0.95)

percpval(Ti, theta0 = 0)
}
\arguments{
\item{Ti}{A numeric vector of bootstrap replicates of an estimate.}

\item{conf.level}{Confidence level.}

\item{theta0}{Null hypothesis value of estimand.}
}
\value{
\code{percci} returns only a two-sided confidence interval and
 \code{percpval} returns only a two-sided p-value.
}
\description{
Input vector of bootstrap replicates and get either the two-sided percentile
confidence interval or the compatible two-sided p-value.
}
\details{
Simple functions, where \code{percci} gives two-sided confidence intevals
and \code{percpval} gives two-sided p-values.

We get a two-sided p-value by inverting the percentile Bootstrap
confidence interval. This is not straightforward if there are not enough
bootstrap samples and/or if the minimum and maximum of the replicates do not
cover the null value. If there are B bootstrap resamples, then the interval
from the minimum to the maximum has confidence level =1- 2/(B+1).
We can see this because the percentile interval
(see Efron and Tibshirani, 1993, p. 160 bottom) is
T[k], T[B+1-k]   where k=floor( (B+1)*(1-conf.level)/2),
where T is an ordered vector of B test statistics calculated from B
bootstrap replicates (T=Ti[order(Ti)]).
Therefore, if conf.level > 1 - 2/(B+1) then we cannot get a percentile
interval, so if the min and max of T do not surround theta0, then
a two-sided p-value can be stated to be p<= 2/(B+1). If the p-value
is 2/(B+1), then it is the lowest possible for that B, and increasing
B may produce a lower p-value.
}
\section{Functions}{
\itemize{
\item \code{percpval()}: Bootstrap percentile p-values

}}
\examples{
\donttest{
  set.seed(123)
  y<- rnorm(100)+0.1
  nB<- 1e5
  Tstat<- rep(NA,nB)
  for (i in 1:nB){
    Tstat[i]<-mean( sample(y,replace=TRUE) )
   }
   # two-sided bootstrap percentile p-value
   # that mean is different from 0
   percpval(Tstat,theta0=0)
   # 95\% percentile interval
   percci(Tstat)
   # compare to t-test
   t.test(y)

   # to show that the functions are close to compatiable
   # set confidence level to 1-pvalue
   pval<-percpval(Tstat,theta0=0)
   confLevel<- 1-pval
   pval
   # then lower limit should be close to 0
   percci(Tstat, conf.level=confLevel)
  }
}
\references{
Efron, B and Tibshirani, RJ (1993) An Introduction to the Bootstrap.
 Chapman and Hall.
}
