% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{passed_pairs}
\alias{passed_pairs}
\title{Get Passed Comparisons from Batch Results}
\usage{
passed_pairs(object)
}
\arguments{
\item{object}{An \code{odiffr_batch} object from \code{\link[=compare_images_batch]{compare_images_batch()}} or
\code{\link[=compare_image_dirs]{compare_image_dirs()}}.}
}
\value{
A tibble or data.frame containing only rows where \code{match} is \code{TRUE}.
}
\description{
Extract only the passed (matching) comparisons from batch results.
}
\examples{
\dontrun{
results <- compare_image_dirs("baseline/", "current/")
passed <- passed_pairs(results)
nrow(passed)  # Number of passing comparisons
}
}
\seealso{
\code{\link[=compare_images_batch]{compare_images_batch()}}, \code{\link[=compare_image_dirs]{compare_image_dirs()}}, \code{\link[=failed_pairs]{failed_pairs()}}
}
