% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_numeric_vector.R
\name{check_numeric_vector}
\alias{check_numeric_vector}
\alias{assert_numeric_vector}
\alias{test_numeric_vector}
\title{Check numeric vector}
\usage{
check_numeric_vector(
  x,
  lower = -Inf,
  upper = Inf,
  finite = FALSE,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  sorted = FALSE,
  names = NULL,
  typed.missing = FALSE,
  null.ok = FALSE
)

assert_numeric_vector(
  x,
  lower = -Inf,
  upper = Inf,
  finite = FALSE,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  sorted = FALSE,
  names = NULL,
  typed.missing = FALSE,
  null.ok = FALSE,
  .var.name = checkmate::vname(x),
  add = NULL
)

test_numeric_vector(
  x,
  lower = -Inf,
  upper = Inf,
  finite = FALSE,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  sorted = FALSE,
  names = NULL,
  typed.missing = FALSE,
  null.ok = FALSE
)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{lower}{[\code{numeric(1)}]\cr
Lower value all elements of \code{x} must be greater than or equal to.}

\item{upper}{[\code{numeric(1)}]\cr
Upper value all elements of \code{x} must be lower than or equal to.}

\item{finite}{[\code{logical(1)}]\cr
Check for only finite values? Default is \code{FALSE}.}

\item{any.missing}{[\code{logical(1)}]\cr
Are vectors with missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are vectors with no non-missing values allowed? Default is \code{TRUE}.
Note that empty vectors do not have non-missing values.}

\item{len}{[\code{integer(1)}]\cr
Exact expected length of \code{x}.}

\item{min.len}{[\code{integer(1)}]\cr
Minimal length of \code{x}.}

\item{max.len}{[\code{integer(1)}]\cr
Maximal length of \code{x}.}

\item{unique}{[\code{logical(1)}]\cr
Must all values be unique? Default is \code{FALSE}.}

\item{sorted}{[\code{logical(1)}]\cr
Elements must be sorted in ascending order. Missing values are ignored.}

\item{names}{[\code{character(1)}]\cr
Check for names. See \code{\link[checkmate]{checkNamed}} for possible values.
Default is \dQuote{any} which performs no check at all.
Note that you can use \code{\link[checkmate]{checkSubset}} to check for a specific set of names.}

\item{typed.missing}{[\code{logical(1)}]\cr
If set to \code{FALSE} (default), all types of missing values (\code{NA}, \code{NA_integer_},
\code{NA_real_}, \code{NA_character_} or \code{NA_character_}) as well as empty vectors are allowed
while type-checking atomic input.
Set to \code{TRUE} to enable strict type checking.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link[checkmate]{AssertCollection}}.}
}
\value{
Same as documented in \code{\link[checkmate]{check_numeric}}.
}
\description{
These functions check whether the input is a numeric vector.
}
\examples{
x <- c(1, 2, "3")
check_numeric_vector(x)
test_numeric_vector(x)
\dontrun{
assert_numeric_vector(x)
}
}
\seealso{
Other vector helpers: 
\code{\link{check_probability_vector}()},
\code{\link{chunk_vector}()},
\code{\link{equidistant_vectors}()},
\code{\link{insert_vector_entry}()},
\code{\link{map_indices}()},
\code{\link{match_numerics}()},
\code{\link{permutations}()},
\code{\link{split_vector_at}()},
\code{\link{subsets}()},
\code{\link{vector_occurrence}()}
}
\concept{vector helpers}
\keyword{validation}
