% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrapers.R
\name{get_oai_meta_from_article}
\alias{get_oai_meta_from_article}
\title{Retrieving OAI records for OJS articles}
\usage{
get_oai_meta_from_article(input_url, verbose = FALSE)
}
\arguments{
\item{input_url}{Character vector.}

\item{verbose}{Logical.}
}
\value{
A long-format dataframe with the url you provided (input_url), the name of the metadata (meta_data_name),
and the content of the metadata (meta_data_content).
}
\description{
This functions access OAI records (within OJS) for any article for which you provided an URL.
}
\details{
Several limitations are in place. Please refer to vignette.
}
\examples{
\donttest{
article <- 'https://dspace.palermo.edu/ojs/index.php/psicodebate/article/view/516/311'
metadata_oai <- ojsr::get_oai_meta_from_article(input_url = article)
}
}
