% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KwOLL-G.R
\name{KwOLLG}
\alias{KwOLLG}
\alias{pkwollg}
\alias{dkwollg}
\alias{qkwollg}
\alias{rkwollg}
\alias{hkwollg}
\title{Kumaraswamy Odd log-logistic family of distributions (KwOLL-G)}
\usage{
pkwollg(x, alpha = 1, a = 1, b = 1, G = pnorm, ...)

dkwollg(x, alpha = 1, a = 1, b = 1, G = pnorm, ...)

qkwollg(q, alpha = 1, a = 1, b = 1, G = pnorm, ...)

rkwollg(n, alpha = 1, a = 1, b = 1, G = pnorm, ...)

hkwollg(x, alpha = 1, a = 1, b = 1, G = pnorm, ...)
}
\arguments{
\item{x}{scaler or vector of values at which the pdf or cdf needs to be computed.}

\item{alpha}{the value of the first shape parameter, must be positive, the default is 1.}

\item{a}{the value of the shape parameter, must be positive, the default is 1.}

\item{b}{the value of the shape parameter, must be positive, the default is 1.}

\item{G}{A baseline continuous cdf.}

\item{...}{The baseline cdf parameters.}

\item{q}{scaler or vector of probabilities at which the quantile needs to be computed.}

\item{n}{number of random numbers to be generated.}
}
\value{
\code{pkwollg} gives the distribution function,
 \code{dkwollg} gives the density,
 \code{qkwollg} gives the quantile function,
 \code{hkwollg} gives the hazard function and
 \code{rkwollg} generates random variables from the Kumaraswamy Odd log-logistic family of
 distributions (KwOLL-G) for baseline cdf G.
}
\description{
Computes the pdf, cdf, hdf, quantile and random numbers
of the beta extended distribution due to Alizadeh et al. (2017) specified by the pdf
\deqn{f=\frac{a\,b\,\alpha\,g\,G^{a\,\alpha-1}\bar{G}^{\alpha-1}}{[G^\alpha+\bar{G}^\alpha]^{a+1}}\times \{1-[\frac{G^\alpha}{G^\alpha+\bar{G}^\alpha}]^a\}^{b-1}}
for \eqn{G} any valid continuous cdf , \eqn{\bar{G}=1-G}, \eqn{g} the corresponding pdf, \eqn{a, b > 0}, the shape parameter, \eqn{\alpha > 0}, the first shape parameter.
}
\examples{
x <- seq(0, 1, length.out = 21)
pkwollg(x)
pkwollg(x, alpha = 2, a = 2, b = 2, G = pbeta, shape1 = 1, shape2 = 2)
dkwollg(x, alpha = 2, a = 2, b = 2, G = pbeta, shape1 = 1, shape2 = 2)
curve(dkwollg, -3, 3)
qkwollg(x, alpha = 2, a = 2, b = 2, G = pbeta, shape1 = 1, shape2 = 2)
n <- 10
rkwollg(n, alpha = 2, a = 2, b = 2, G = pbeta, shape1 = 1, shape2 = 2)
hkwollg(x, alpha = 2, a = 2, b = 2, G = pbeta, shape1 = 1, shape2 = 2)
curve(hkwollg, -3, 3)
}
\references{
Alizadeh, M., Emadi, M., Doostparast, M., Cordeiro, G. M., Ortega, E. M., Pescim, R. R. (2015). A new family of distributions: the Kumaraswamy odd log-logistic, properties and applications. Hacettepe Journal of Mathematics and Statistics, 44(6), 1491-1512.
}
