% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBOLL-G.R
\name{RBOLLG}
\alias{RBOLLG}
\alias{prbollg}
\alias{drbollg}
\alias{qrbollg}
\alias{rrbollg}
\alias{hrbollg}
\title{The Ristic-Balakrishnan  Odd log-logistic family of distributions (RBOLL-G)}
\usage{
prbollg(x, alpha = 1, beta = 1, G = pnorm, ...)

drbollg(x, alpha = 1, beta = 1, G = pnorm, ...)

qrbollg(q, alpha = 1, beta = 1, G = pnorm, ...)

rrbollg(n, alpha = 1, beta = 1, G = pnorm, ...)

hrbollg(x, alpha = 1, beta = 1, G = pnorm, ...)
}
\arguments{
\item{x}{scaler or vector of values at which the pdf or cdf needs to be computed.}

\item{alpha}{the value of the first shape parameter, must be positive, the default is 1.}

\item{beta}{the value of the second shape parameter, must be positive, the default is 1.}

\item{G}{A baseline continuous cdf.}

\item{...}{The baseline cdf parameters.}

\item{q}{scaler or vector of probabilities at which the quantile needs to be computed.}

\item{n}{number of random numbers to be generated.}
}
\value{
\code{prbollg} gives the distribution function,
 \code{drbollg} gives the density,
 \code{qrbollg} gives the quantile function,
 \code{hrbollg} gives the hazard function and
 \code{rrbollg} generates random variables from the The Ristic-Balakrishnan  Odd log-logistic family of
 distributions (RBOLL-G) for baseline cdf G.
}
\description{
Computes the pdf, cdf, hdf, quantile and random numbers of the beta extended distribution due to Esmaeili et al. (2020) specified by the pdf
\deqn{f=\frac{\alpha\,g\,G^{\alpha-1}\bar{G}^{\alpha-1}}{\Gamma(\beta)[G^\alpha+\bar{G}^\alpha]^2}\,\{-\log[\frac{G^\alpha}{G^\alpha+\bar{G}^\alpha}]\}^{\beta-1}}
for \eqn{G} any valid continuous cdf , \eqn{\bar{G}=1-G}, \eqn{g} the corresponding pdf, \eqn{\Gamma(\beta)} the Gamma funcion, \eqn{\alpha > 0}, the first shape parameter, and \eqn{\beta > 0}, the second shape parameter.
}
\examples{
x <- seq(0, 1, length.out = 21)
prbollg(x)
prbollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
drbollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
curve(drbollg, -3, 3)
qrbollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)

n <- 10
rrbollg(n, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)

hrbollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
curve(hrbollg, -3, 3)
}
\references{
Esmaeili, H., Lak, F., Altun, E. (2020). The Ristic-Balakrishnan odd log-logistic family of distributions: Properties and Applications. Statistics, Optimization Information Computing, 8(1), 17-35.
}
