% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_layout.R
\name{view_layout}
\alias{view_layout}
\title{Generate Annotated Layout for Report Templates}
\usage{
view_layout(
  template = file.path(system.file(package = "onbrand"), "templates", "report.pptx"),
  output_file = NULL,
  verbose = TRUE
)
}
\arguments{
\item{template}{Name of PowerPoint or Word file to annotate (defaults to included PoerPoint template)}

\item{output_file}{name of file to place the annotated layout information, set to \code{NULL} and it will generate a file named layout with the appropriate extension}

\item{verbose}{Boolean variable when set to TRUE (default) messages will be}
}
\value{
List with the following elements
\itemize{
\item{isgood}: Boolean variable indicating success or failure
\item{rpt}: Officer with the annotated layout
\item{msgs}: Vector of messages
}
}
\description{
Produces a report with each layout element labeled.
}
\details{
Generates an Annotated report based on the template provided.  
Elements of slide masters are identified by placeholder labels. As PowerPoint 
masters are created the labels can be difficult to predict. Word documents are 
identified by style names. This function will create a layout file identifying 
all of the elements of each slide master for a PowerPoint template or each 
paragraph and table style for a Word template.
}
\examples{
lpptx = view_layout(
     template = file.path(system.file(package="onbrand"), "templates", "report.pptx"),
     output_file   = file.path(tempdir(), "layout.pptx"))

ldocx = view_layout(
     template = file.path(system.file(package="onbrand"), "templates", "report.docx"),
     output_file   = file.path(tempdir(), "layout.docx"))
}
