% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-oneinfl.R
\name{summary.oneinflmodel}
\alias{summary.oneinflmodel}
\title{Summarize One-Inflated Regression Models}
\usage{
\method{summary}{oneinflmodel}(object, ...)
}
\arguments{
\item{object}{A model object of class `"oneinflmodel"` (for one-inflated models).}

\item{...}{Additional arguments (currently unused).}
}
\value{
Prints a summary table of coefficients, standard errors, z-values, p-values, 
significance codes, one-inflation probabilities, and log-likelihood.
}
\description{
Provides a summary of the fitted model, including estimated coefficients, standard errors, 
significance levels, and other relevant statistics.
}
\details{
This function generates a detailed summary of the fitted model, including:
- Estimated coefficients for the rate component (\code{beta}).
- Estimated coefficients for the one-inflation component (\code{gamma}).
- Standard errors.
- z-statistics, associated p-values, and corresponding significance codes.
- Average, and average absolute, one-inflation.
- Log-likelihood of the fitted model.
}
\examples{
# Example usage
df <- data.frame(x = rnorm(100), z = rnorm(100), y = rpois(100, lambda = 5))
model <- oneinfl(y ~ x | z, df = df, dist = "Poisson")
summary(model)

}
\seealso{
\code{\link{oneinfl}} for fitting one-inflated models.
}
