% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argument_types.R
\name{MetadataFilter}
\alias{MetadataFilter}
\title{MetadataFilter}
\value{
Object of \code{\link[R6:R6Class]{R6::R6Class()}} representing a list of \code{\link[=Process]{Process()}} in order to filter for collections.
}
\description{
Inheriting from \link{ProcessGraphArgument} in order to represent a list of functions that is internally
interpreted into \code{\link[=Process]{Process()}} objects.
}
\examples{
\dontrun{
# define filter statement
filter = list(
   "eo:cloud_cover" = function(x) x >= 0 & x < 50, 
   "platform" = function(x) x == "Sentinel-2A"
)

# setting the arguments is done via the process graph building with of 'processes()'
}

}
\seealso{
\link{Array}, \link{Integer}, \link{EPSGCode}, \link{String}, \link{Number},
\link{Date}, \link{DataCube}, \link{ProcessGraphArgument},
\link{ProcessGraphParameter}, \link{OutputFormatOptions}, \link{GeoJson},
\link{Boolean}, \link{DateTime}, \link{Time}, \link{BoundingBox}, \link{Kernel},
\link{TemporalInterval}, \link{TemporalIntervals}, \link{CollectionId}, \link{OutputFormat},
\link{AnyOf}, \link{ProjDefinition}, \link{UdfCodeArgument}, \link{UdfRuntimeArgument} and
\link{UdfRuntimeVersionArgument}, \link{MetadataFilter}
}
