% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oms-ReadMicrodata.R
\name{get_run_microdata}
\alias{get_run_microdata}
\alias{get_run_microdata_csv}
\title{Read Run Microdata}
\usage{
get_run_microdata(model, run, name)

get_run_microdata_csv(model, run, name)
}
\arguments{
\item{model}{Model digest or model name.}

\item{run}{Model run digest, run stamp or run name, modeling task run
stamp, or task run name.}

\item{name}{Microdata entity name.}
}
\value{
A \code{list} or \code{tibble}.
}
\description{
Functions for retrieving microdata from model runs. More information about
these API endpoints can be found at \href{https://github.com/openmpp/openmpp.github.io/wiki/Oms-web-service-API#read-parameters-output-tables-or-microdata-values}{here}.
}
\examples{
\dontrun{
use_OpenMpp_local()
get_run_microdata_csv("RiskPaths", "53300e8b56eabdf5e5fb112059e8c137", "Person")
}

}
