% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassModelRun.R
\name{load_model_run}
\alias{load_model_run}
\alias{load_run}
\alias{OpenMppModelRun}
\title{OpenM++ ModelRun Class}
\usage{
load_model_run(model, run)

load_run(model, run)
}
\arguments{
\item{model}{Model digest or model name.}

\item{run}{Model run digest, run stamp or run name, modeling task run
stamp or task run name.}
}
\value{
An \code{OpenMppModelRun} instance.
}
\description{
OpenM++ ModelRun Class
}
\details{
\code{load_run()} is an alias for \code{load_model_run()}.
}
\examples{
\dontrun{
use_OpenMpp_local()
load_model_run("RiskPaths", "53300e8b56eabdf5e5fb112059e8c137")
load_run("RiskPaths", "53300e8b56eabdf5e5fb112059e8c137")
}

}
\section{Super class}{
\code{\link[openmpp:OpenMppModel]{openmpp::OpenMppModel}} -> \code{OpenMppModelRun}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{RunName}}{Run name.}

\item{\code{RunDigest}}{Run digest.}

\item{\code{RunStamp}}{Run stamp.}

\item{\code{RunMetadata}}{Run metadata.}

\item{\code{Parameters}}{Model run parameters.}

\item{\code{Tables}}{Model run output tables}

\item{\code{OpenMppType}}{OpenM++ object type (used for \code{print()}).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{RunStatusInfo}}{Run status information.}

\item{\code{RunStatus}}{Run status.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OpenMppModelRun-new}{\code{OpenMppModelRun$new()}}
\item \href{#method-OpenMppModelRun-print}{\code{OpenMppModelRun$print()}}
\item \href{#method-OpenMppModelRun-get_table}{\code{OpenMppModelRun$get_table()}}
\item \href{#method-OpenMppModelRun-get_table_acc}{\code{OpenMppModelRun$get_table_acc()}}
\item \href{#method-OpenMppModelRun-get_table_calc}{\code{OpenMppModelRun$get_table_calc()}}
\item \href{#method-OpenMppModelRun-get_table_comparison}{\code{OpenMppModelRun$get_table_comparison()}}
\item \href{#method-OpenMppModelRun-write_table}{\code{OpenMppModelRun$write_table()}}
\item \href{#method-OpenMppModelRun-write_tables}{\code{OpenMppModelRun$write_tables()}}
\item \href{#method-OpenMppModelRun-get_log}{\code{OpenMppModelRun$get_log()}}
\item \href{#method-OpenMppModelRun-write_log}{\code{OpenMppModelRun$write_log()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppModelRun-new"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppModelRun-new}{}}}
\subsection{Method \code{new()}}{
Create a new OpenMppModelRun object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppModelRun$new(model, run)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{Model digest or name.}

\item{\code{run}}{Run digest, run stamp, or run name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{OpenMppModelRun} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppModelRun-print"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppModelRun-print}{}}}
\subsection{Method \code{print()}}{
Print a \code{OpenMppModelRun} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppModelRun$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Not currently used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppModelRun-get_table"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppModelRun-get_table}{}}}
\subsection{Method \code{get_table()}}{
Retrieve a table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppModelRun$get_table(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{tibble}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppModelRun-get_table_acc"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppModelRun-get_table_acc}{}}}
\subsection{Method \code{get_table_acc()}}{
Retrieve a table with all accumulator values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppModelRun$get_table_acc(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{tibble}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppModelRun-get_table_calc"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppModelRun-get_table_calc}{}}}
\subsection{Method \code{get_table_calc()}}{
Retrieve a table calculation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppModelRun$get_table_calc(name, calc)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name.}

\item{\code{calc}}{Name of calculation. One of \code{"avg"}, \code{"sum"}, \code{"count"},
\code{"max"}, \code{"min"}, \code{"var"}, \code{"sd"}, \code{"se"}, or \code{"cv"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{tibble}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppModelRun-get_table_comparison"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppModelRun-get_table_comparison}{}}}
\subsection{Method \code{get_table_comparison()}}{
Retrieve a table comparison.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppModelRun$get_table_comparison(name, compare, variant)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name.}

\item{\code{compare}}{Comparison to calculate. One of \code{"diff"}, \code{"ratio"}, or
\code{"percent"}.}

\item{\code{variant}}{Run digest, name, or stamp for the variant model run.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{tibble}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppModelRun-write_table"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppModelRun-write_table}{}}}
\subsection{Method \code{write_table()}}{
Write an output table to disk (CSV).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppModelRun$write_table(name, file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name.}

\item{\code{file}}{File path.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppModelRun-write_tables"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppModelRun-write_tables}{}}}
\subsection{Method \code{write_tables()}}{
Write all output tables to disk (CSV).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppModelRun$write_tables(dir)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir}}{Directory path.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppModelRun-get_log"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppModelRun-get_log}{}}}
\subsection{Method \code{get_log()}}{
Get console log for model run.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppModelRun$get_log()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppModelRun-write_log"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppModelRun-write_log}{}}}
\subsection{Method \code{write_log()}}{
Write console log for model run to disk.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppModelRun$write_log(dir)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir}}{Directory to save log file.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
}
