print.summary.optbdmaeAT<-function(x,...)
{
cat("\n        ---------------------------------------    \n")
cat("Title:  ",x$Optcrit,"-optimal or near-optimal block design        ","Date: ", format(Sys.time(), "%a %b %d %Y %H:%M:%S"),"\n",sep="")
cat("        ---------------------------------------    \n")
cat("Call:\n")
print(x$call)
cat("\nparametric combintaions:\n")
cat("\nNumber of treamtments:         ", x$v, "\n")
cat("Number of blocks:              ", x$b, "\n")
cat("Theta value:                   ",  x$theta, "\n")
cat("Number of replications:        ",  x$nrep, "\n")
cat("Number of exchange iteration:  ", x$itr.cvrgval, "\n")
cat("Algorithm used:                ", x$Alg, "\n")
cat("OPtimality criterion used:      ", x$Optcrit, "-optimality criteria\n",sep="")
cat("\nResultant ",x$Optcrit,"-optimal or near-optimal block design:\n",sep="")
cat("\n")
print(data.frame(x$OptdesF))
cat("\n")
cat(x$Optcrit,"-Score value:  ", x$Optcrtsv, "\n",sep="")
plot(x$grphlt,edge.arrow.size=5, vertex.size=20, margin=0.5,
       layout=layout.kamada.kawai,vertex.color="cyan",edge.color="black")
title(paste("Graphical layout of", paste(x$Optcrit,"-optimal or near-optimal block design",sep=""),sep=" "), 
      sub = NULL,cex.main = 1,   font.main= 1, col.main= "black")
mtext(paste("using"," ",x$Alg,"-algorithm for:",sep=""), line = 0.5, col = "black", font = 1)
mtext(paste("(v, b, theta) =", " (",paste(x$v, x$b, x$theta, sep=", "),")",sep=""), line = -0.50, col = "blue", font = 1)
cat("\n", x$file_loc2,"\n", x$file_loc,"\n")
cat("\n")
}
