% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crit_eff.R
\name{eff}
\alias{eff}
\title{Efficiency between two Information Matrices}
\usage{
eff(criterion, mat1, mat2, k = 0, intPars = c(1), matB = NA)
}
\arguments{
\item{criterion}{character variable with the chosen optimality criterion. Can be one of the following:
\itemize{
\item 'D-Optimality'
\item 'Ds-Optimality'
\item 'A-Optimality'
\item 'I-Optimality'
\item 'L-Optimality'
}}

\item{mat1}{first information matrix, for the numerator.}

\item{mat2}{second information matrix, for the denominator.}

\item{k}{number of parameters of the model. Taken from the number of rows of the matrix if omitted.}

\item{intPars}{numeric vector with the index of the parameters of interest of the model. Only for "Ds-Optimality".}

\item{matB}{matrix of the integral of the information matrix over the interest region. Only for "I-Optimality".}
}
\value{
Efficiency of first design with respect to the second design, as a decimal number.
}
\description{
Efficiency between two Information Matrices
}
