% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inf_mat_sens.R
\name{sens}
\alias{sens}
\title{Master function to calculate the sensitivity function}
\usage{
sens(Criterion, grad, M, par_int = c(1), matB = NA)
}
\arguments{
\item{Criterion}{character variable with the chosen optimality criterion. Can be one of the following:
\itemize{
\item 'D-Optimality'
\item 'Ds-Optimality'
\item 'A-Optimality'
\item 'I-Optimality'
\item 'L-Optimality'
}}

\item{grad}{A function in a single variable that returns the partial derivatives vector of the model.}

\item{M}{Information Matrix for the sensitivity function.}

\item{par_int}{Numeric vector of the indexes of the parameters of interest for Ds-Optimality.}

\item{matB}{Matrix resulting from the integration of the one-point Information Matrix along the interest
region or lineal matrix for L-Optimality.}
}
\value{
The sensitivity function as a matrix of single variable.
}
\description{
Calculates the sensitivity function given the desired \code{Criterion}, an information matrix and other
necessary values depending on the chosen criterion.
}
