% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validator.R
\name{v_numeric_range}
\alias{v_numeric_range}
\title{Validator for Numeric Values Within a Range}
\usage{
v_numeric_range(min = -Inf, max = Inf)
}
\arguments{
\item{min}{Minimum allowed value (inclusive). Defaults to \code{-Inf} (no lower bound).}

\item{max}{Maximum allowed value (inclusive). Defaults to \code{Inf} (no upper bound).}
}
\value{
A validator function that takes a value \code{x} and raises an error if:
\itemize{
\item \code{x} is not a single numeric value
\item \code{x} is less than \code{min} or greater than \code{max}
}
}
\description{
\code{v_numeric_range()} returns a validator function that checks if a value
is a single numeric value within a specified range. This is useful as a
validator function for bounded numeric options in options managers created
with \code{\link[=create_options_manager]{create_options_manager()}}.
}
\examples{
# Create a validator for values between 0 and 1
validator <- v_numeric_range(min = 0, max = 1)

# Valid inputs
validator(0.5)
validator(0)
validator(1)

# Invalid inputs (would raise errors)
try(validator(-0.1)) # below minimum
try(validator(1.5)) # above maximum
try(validator(c(0.5, 0.7))) # vector, not scalar
}
