get_nice_parameter_name <- function(parameter_name) {
  nice_name <- switch(
    EXPR = parameter_name,
    # ab_data_param / sc_sample_data_param / sc_ref_data_param / refl_data_param
    NSN = "Scan Number",
    NOF = "NOF",
    DPF = "Data Point Format",
    NPT = "Number of Data Points",
    FXV = "Frequency of First Point",
    LXV = "Frequency of Last Point",
    CSF = "Y - Scaling Factor",
    MXY = "Y - Maximum",
    MNY = "Y - Minimum",
    DAT = "Date of Measurement",
    TIM = "Time of Measurement",
    DXU = "X Units",
    TPX = "unknown",
    # quant_report_refl
    BID = "Block Identifier",
    # NRP = ,
    # SIZ = ,
    TIT = "Title",
    # E00 = ,
    # F00 = ,
    # Z00 = ,
    # optics / optics_ref
    ACC = "Accessory",
    APR = "ATR Pressure",
    APT = "Aperture Setting",
    BMS = "Beamsplitter Setting",
    CHN = "Measurement Channel",
    CHX = "OPVX Measurement Channel",
    CRM = "Correlation Rejection Mask",
    DTC = "Detector Setting",
    HPF = "High Pass Filter",
    LPF = "Low Pass Filter",
    LPV = "Variable Low Pass Filter(cm-1)",
    OPF = "Optical Filter Setting",
    PGN = "Preamplifier Gain",
    PGR = "Preamplifier Gain Background",
    RCH = "Extended Ready Check", # check if really named like this
    RDX = "Extended Ready Check",
    SRC = "Source Setting",
    VEL = "Scanner Velocity",
    ADC = "Ext. Analog Signals",
    SON = "External Synchronisation",
    # aquisition /aquisition_ref
    ADT = "Additional Data Treatment",
    AQM = "Acquisition Mode",
    CFE = "Low intensity power mode with DTGS",
    COR = "Correlation Test Mode",
    DEL = "Delay Before Measurement",
    DLY = "Stabilization Delay",
    HFW = "Wanted High Frequency Limit",
    LFW = "Wanted Low Frequency Limit",
    NSR = "Background Scans",
    NSS = "Sample Scans",
    PLF = "Result Spectrum",
    RES = "Resolution",
    RMD = "Rotation Mode",
    SOT = "Sample Scans or Time",
    RGN = "Signal Gain, Background",
    AGQ = "Actual Signal Gain 2nd Channel",
    STR = "BG Scans or Time",
    TCL = "Command line for Additional Data Treatment",
    TDL = "To do list",
    RPO = "Background Number",
    SPO = "Sample Number",
    SGN = "Signal Gain, Sample",
    # fourier_transformation / fourier_transformation_ref
    APF = "Apodization Function",
    HFQ = "End Frequency Limit for File",
    LFQ = "Start Frequency Limit for File",
    NLI = "Non Linearity Correction",
    PHR = "Phase Resolution",
    PHZ = "Phase Correction Mode",
    SPZ = "Stored Phase Mode",
    ZFF = "Zero Filling Factor",
    # sample
    BLD = "Building",
    CNM = "Operator Name",
    CPY = "Company",
    DPM = "Department",
    EXP = "Experiment",
    LCT = "Location",
    SFM = "Sample Form",
    SNM = "Sample Name",
    XPP = "Experiment Path",
    IST = "Instrument Status",
    CPG = "Character encoding code page",
    UID = "Universally Unique Identifier",
    MID = "MID",
    # instrument / instrument_ref
    HFL = "Hight Folding Limit",
    LFL = "Low Folding Limit",
    LWN = "Laser Wavenumber",
    ABP = "Absolute Peak Pos in Laser*2",
    SSP = "Sample Spacing Divisor",
    SSM = "Sample Spacing Multiplicator",
    ASG = "Actual Signal Gain",
    ARG = "Actual Ref. Signal Gain",
    APG = "Actual preamplifier gain",
    HUA = "Absolute Humidity Interferometer",
    NFL = "Nominal FW Peak Pos in Points",
    ASS = "Number of Sample Scans",
    GFW = "Number of Good FW Scans",
    GBW = "Number of Good BW Scans",
    BFW = "Number of Bad FW Scans",
    BBW = "Number of Bad BW Scans",
    PKA = "Peak Amplitude",
    PKL = "Peak Location",
    PRA = "Backward Peak Amplitude",
    PRL = "Backward Peak Location",
    P2A = "Peak Amplitude 2nd Channel",
    P2L = "Peak Location 2nd Channel",
    P2R = "Backward Peak Amplitude 2nd Channel",
    P2K = "Backward Peak Location 2nd Channel",
    DAQ = "Data Aquisition Status",
    AG2 = "Actual Signal Gain 2nd Channel",
    HUM = "Relative Humidity Interferometer",
    RSN = "Running Sample Number",
    CRR = "Correlation rejection reason",
    SRT = "Start time (sec)",
    DUR = "Scan time (sec)",
    TSC = "Scanner Temperature",
    MVD = "Max. Velocity Deviation",
    AN1 = "Analog Signal 1",
    AN2 = "Analog Signal 2",
    VSN = "Firmware version",
    SRN = "Instrument Serial Number",
    NLA = "NL Alpha",
    NLB = "NL Beta",
    INC = "FT Detector Cutoff Freq.",
    INE = "FT Modulation Efficiency",
    CAM = "Coaddition mode",
    INS = "Instrument Type",
    FOC = "Focal Length",
    RDY = "Ready Check",
    WND = "Optical windows",
    ARS = "Number of Background Scans",
    # lab_and_process_param_2
    FC1 = "Product Group",
    FC2 = "Product",
    FD0 = "Label Product Info 1",
    FD1 = "Value Product Info 1",
    FD2 = "Label Product Info 2",
    FD3 = "Value Product Info 2",
    FE1 = "Device Type",
    FE2 = "Device Description",
    FE3 = "Measurement Position Microplate",
    # info_block
    INP = "Info Text Path",
    INM = "Info Definition Filename",
    IFN = "Operator",
    I01 = "Group",
    T01 = "Text:Group",
    I02 = "Name",
    T02 = "Text:Name",
    I03 = "Sample ID",
    T03 = "Text:Sample ID",
    I04 = "User1",
    T04 = "Text:User1",
    I05 = "User2",
    T05 = "Text:User2",
    I06 = "Quant01",
    T06 = "Text:Quant01",
    I07 = "Quant11",
    T07 = "Text:Quant11",
    T08 = "Text:Quant21",
    MOP = "Data Layout"
  )
  # nolint end

  return(nice_name)
}

sort_list_by <- function(dataset_list) {
  sort_by <- c(
    "refl_no_atm_comp_data_param",
    "refl_no_atm_comp",
    "refl_data_param",
    "refl",
    "quant_report_refl",
    "ab_no_atm_comp_data_param",
    "ab_no_atm_comp",
    "ab_data_param",
    "ab",
    "quant_report_ab",
    "me_test_report_ab",
    "sc_sample_data_param",
    "sc_sample",
    "ig_sample_data_param",
    "ig_sample",
    "sc_ref_data_param",
    "sc_ref",
    "ig_ref_data_param",
    "ig_ref",
    "match_data_param",
    "match",
    "match_2_chn_data_param",
    "match_2_chn",
    "optics",
    "optics_ref",
    "acquisition_ref",
    "fourier_transformation_ref",
    "fourier_transformation",
    "sample",
    "acquisition",
    "instrument_ref",
    "instrument",
    "lab_and_process_param",
    "lab_and_process_param_raw",
    "lab_and_process_param_processed",
    "info_block",
    "quality_test_report",
    "history",
    "report_unknown",
    "unknown"
  )

  to_sort_by <- intersect(sort_by, names(dataset_list))

  dataset_list <- dataset_list[to_sort_by]

  return(dataset_list)
}
