% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.R
\name{orderly_example_show}
\alias{orderly_example_show}
\title{Show an example file}
\usage{
orderly_example_show(name, file = NULL, example = "demo")
}
\arguments{
\item{name}{The name of the report within the example.}

\item{file}{The name of the file within the report.  The default
is to show the main orderly file (i.e., \verb{<name>.R})}

\item{example}{The name of the example to look in.  The default
\code{demo} is a sprawling set of source designed to show off
different orderly features.}
}
\value{
Nothing, called for its side effects only.
}
\description{
Show a file from within one of the examples.  This function exists
for use within orderly help files, vignettes and tutorials and is
not meant to form part of your workflows, unless you are doing
something very peculiar.
}
\details{
All orderly examples here are runnable, though some will naturally
have some pre-requisites (e.g., using a dependency will require
that the dependency has been run first).
}
\examples{
# We use constructions like this in the help, to show off features
# of orderly:
orderly_example_show("data")

# You can run this example:
path <- orderly_example()
orderly_run("data", root = path)
}
