
# orthanc <img src="man/figures/logo.png" align="right" height="120" alt="" />

<!-- badges: start -->

[![Lifecycle:
experimental](https://img.shields.io/badge/lifecycle-experimental-orange.svg)](https://lifecycle.r-lib.org/articles/stages.html#experimental)
[![R-CMD-check](https://github.com/mattwarkentin/orthanc/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/mattwarkentin/orthanc/actions/workflows/R-CMD-check.yaml)
<!-- badges: end -->

`orthanc` is an R package that provides a programmatic interface to
[Orthanc](https://orthanc.uclouvain.be) DICOM Servers to support medical
imaging workflows for the R language. Inspired by the design and
usability of the [`PyOrthanc`](https://github.com/gacou54/pyorthanc)
Python package, `orthanc` enables R users to interact with Orthanc
servers using familiar R paradigms.

The package provides comprehensive and user-friendly access to the
Orthanc REST API, designed to align with idiomatic R workflows while
preserving the structure and semantics of DICOM resources.

`orthanc` provides:

- Comprehensive wrapping of the Orthanc REST API endpoints using
  [`httr2`](https://httr2.r-lib.org)

- Asynchronous client support using [`mirai`](https://mirai.r-lib.org)

- Object-oriented representations of hierarchical DICOM resources using
  [`R6`](https://r6.r-lib.org)

- High-level utility functions for performing common DICOM operations
  including querying, filtering, managing, modifying, and exporting
  DICOM data

## Installation

You can install the development version of `orthanc` from
[GitHub](https://github.com/mattwarkentin/orthanc) with:

``` r
# install.packages("pak")
pak::pak("mattwarkentin/orthanc")
```

## Basic Usage

``` r
library(orthanc)

client <- Orthanc$new("https://orthanc.uclouvain.be/demo")

instances <- client$get_instances()

instances
#> [[1]]
#> [1] "001a7d82-54008387-7b23ad57-8fb6202a-6d3b305b"
#> 
#> [[2]]
#> [1] "001b6592-37c2fbe4-2c07c724-ce9607e2-2bd210e8"
#> 
#> [[3]]
#> [1] "00330d0f-911e5e8d-1e305bae-e5c53b73-d2a49298"
#> 
#> [[4]]
#> [1] "00402ce7-ac05c687-4d0839bc-cecd4fad-3d1b7eed"
#> 
#> [[5]]
#> [1] "00419319-1d16e8d6-2eb65ed2-0de8313f-3356e31e"
#> 
#>  [ reached 'max' / getOption("max.print") -- omitted 2547 entries ]
#> attr(,"class")
#> [1] "orthanc_response" "list"
```

``` r
instance <- Instance$new(instances[[1]], client)
instance
#> <Instance: 001a7d82-54008387-7b23ad57-8fb6202a-6d3b305b>

instance$main_dicom_tags
#> $AcquisitionNumber
#> [1] "4"
#> 
#> $ImageOrientationPatient
#> [1] "1\\0\\0\\0\\1\\0"
#> 
#> $ImagePositionPatient
#> [1] "-249.51171875\\-458.51171875\\364"
#> 
#> $InstanceCreationDate
#> [1] "20151217"
#> 
#> $InstanceCreationTime
#> [1] "125203.943000"
#> 
#>  [ reached 'max' / getOption("max.print") -- omitted 2 entries ]
```

## Acknowledgements

I gratefully acknowledge the authors and maintainers of Orthanc for
developing and maintaining an open-source, standards-compliant DICOM
server that has become an essential tool in medical imaging research. I
also thank the authors and contributors of `PyOrthanc`, whose work
provided important conceptual and design inspiration for this package.

## Code of Conduct

Please note that the `orthanc` project is released with a [Contributor
Code of
Conduct](https://mattwarkentin.github.io/orthanc/CODE_OF_CONDUCT.html).
By contributing to this project, you agree to abide by its terms.
