% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.R
\name{find_instances}
\alias{find_instances}
\title{Finds instances in Orthanc according to queries and labels}
\usage{
find_instances(
  client,
  query = list(),
  labels = character(),
  labels_constraint = "All",
  ...
)
}
\arguments{
\item{client}{Orthanc API client.}

\item{query}{Named-list that specifies the filters on the level related DICOM
tags.}

\item{labels}{Character vector of labels to look for in resources.}

\item{labels_constraint}{Contraint on the labels ('All', 'Any', 'None').}

\item{...}{Additional arguments passed to \code{query_orthanc}.}
}
\value{
A \code{list} of \link{Instance} objects.
}
\description{
Finds instances in Orthanc according to queries and labels
}
\examples{
client <- Orthanc$new("https://orthanc.uclouvain.be/demo")
find_instances(
  client = client,
  query = list(SOPInstanceUID = "1.3.6.1.4.1.14519.5.2.1.2193.7172.260209224923274040650639981398")
)
}
