% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.R
\name{bng_grid}
\alias{bng_grid}
\alias{bng_grid_100km}
\alias{bng_grid_50km}
\alias{bng_grid_10km}
\alias{bng_grid_5km}
\alias{bng_grid_1km}
\title{Map BNG References to Spatial Objects}
\usage{
bng_grid_100km(xmin, ymin, xmax, ymax, ...)

bng_grid_50km(xmin, ymin, xmax, ymax, ...)

bng_grid_10km(xmin, ymin, xmax, ymax, ...)

bng_grid_5km(xmin, ymin, xmax, ymax, ...)

bng_grid_1km(xmin, ymin, xmax, ymax, ...)
}
\arguments{
\item{xmin, ymin, xmax, ymax}{Optional bounding box coordinates.}

\item{...}{Additional arguments. Not currently used.}
}
\value{
Data frame object of type \code{sf} with the grid reference as a
\code{BNGReference} object and the grid square polygon geometry.
}
\description{
Generate a spatial data frame of BNG references and grid square geometries.
}
\details{
These convenience functions generate a spatial data frame of BNG references
and grid square geometries at pre-determined resolutions. This function
combines \code{bbox_to_bng()} and \code{bng_to_grid_geom()} into a data
frame. Optionally, the grid can be for a defined bounding box area of
interest. If the bounding box is omitted, then all grid squares within the
valid bounds of the BNG are returned.

Only selected resolutions are provided to avoid excessively large data
frames. For additional spatial data files of all resolutions, please see the
\href{https://github.com/OrdnanceSurvey/osbng-grids/}{\code{osbng-grids} GitHub repo}.

The \code{sf} package is required for this function.
}
\examples{
\dontshow{if (require("sf")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bng_grid_100km()

bng_grid_1km(529476, 179654, 532170, 181116)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=bbox_to_bng]{bbox_to_bng()}}, \code{\link[=geom_to_bng]{geom_to_bng()}}
}
