% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visu.R
\name{oscar.bs.visu}
\alias{oscar.bs.visu}
\title{Visualize bootstrapping of a fit oscar object}
\usage{
oscar.bs.visu(bs, intercept = FALSE, add = FALSE)
}
\arguments{
\item{bs}{Bootstrapped 3-dimensional array for an oscar object as produced by oscar.bs}

\item{intercept}{Whether model intercept should be plotted also as a coefficient, Default: FALSE}

\item{add}{Should plot be added on top of an existing plot device}
}
\value{
This is a plotting function that does not return anything, but instead draws on an existing or a new graphics device.
}
\description{
This function visualizes bootstrapped model coefficients over multiple bootstrap runs as lines in a graph
}
\examples{
if(interactive()){
  data(ex)
  fit <- oscar(x=ex_X, y=ex_Y, k=ex_K, w=ex_c, family='cox')
  fit_bs <- oscar.bs(fit, bootstrap = 20, seed = 123)
  oscar.bs.visu(fit_bs)
}
}
