% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visu.R
\name{oscar.pareto.visu}
\alias{oscar.pareto.visu}
\title{Visualize oscar model pareto front}
\usage{
oscar.pareto.visu(
  fit,
  cv,
  xval = "cost",
  weak = FALSE,
  summarize = mean,
  add = FALSE,
  ...
)
}
\arguments{
\item{fit}{Fit oscar S4-object}

\item{cv}{A cross-validation matrix as produced by oscar.cv; if CV is not provided, then goodness-of-fit from fit object itself is used rather than cross-validation generalization metric}

\item{xval}{The x-axis to construct pareto front based on; by default 'cost' vector for features/kits, can also be 'cardinality'/'k'}

\item{weak}{If weak pareto-optimality is allowed; by default FALSE.}

\item{summarize}{Function that summarizes over cross-validation folds; by default, this is the mean over the k-folds.}

\item{add}{If the fit should be added on top of an existing plot; in that case leaving out labels etc. By default new plot is called.}

\item{...}{Additional parameters provided for the plotting functions}
}
\value{
This is a plotting function that does not return anything, but instead draws on an existing or a new graphics device.
}
\description{
Visualization function for showing the pareto front for cardinality 'k' and model goodness metric, either from goodness-of-fit or from cross-validation
}
\examples{
if(interactive()){
  data(ex)
  fit <- oscar(x=ex_X, y=ex_Y, k=ex_K, w=ex_c, family='cox')
  fit_cv <- oscar.cv(fit, fold = 10, seed = 123)
  opar <- par(mfrow=c(1,2))
  oscar.pareto.visu(fit=fit) # Model goodness-of-fit
  oscar.pareto.visu(fit=fit, cv=fit_cv) # Model cross-validation performance
  par(opar)
}
}
