% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWASColocQuery.R
\name{gwasColocalisation}
\alias{gwasColocalisation}
\title{Retrieve calculated GWAS colocalisation data}
\usage{
gwasColocalisation(study_locus_id, size = 500, index = 0)
}
\arguments{
\item{study_locus_id}{Character: Open Target Genetics generated ID for the study locus (e.g., "5a86bfd40d2ebecf6ce97bbe8a737512").}

\item{size}{Integer: Number of rows to fetch per page. Default: 500.}

\item{index}{Integer: Page index for pagination. Default: 0.}
}
\value{
Returns a data frame of the studies that colocalise with the input study locus. The table consists of the following data structure:
\itemize{
  \item{\code{study.studyId}:} \emph{Character vector}. Study identifier.
  \item{\code{study.traitReported}:} \emph{Character vector}. Reported trait associated with the colocalisation.
  \item{\code{study.projectId}:} \emph{Character vector}. Project identifier for the study.
  \item{\code{study.publicationFirstAuthor}:} \emph{Character vector}. First author of the publication.
  \item{\code{indexVariant.id}:} \emph{Character vector}. Index variant identifier.
  \item{\code{indexVariant.position}:} \emph{Integer vector}. Index variant position.
  \item{\code{indexVariant.chromosome}:} \emph{Character vector}. Index variant chromosome.
  \item{\code{indexVariant.referenceAllele}:} \emph{Character vector}. Reference allele of the variant.
  \item{\code{indexVariant.alternateAllele}:} \emph{Character vector}. Alternate allele of the variant.
  \item{\code{pValueMantissa}:} \emph{Numeric vector}. Mantissa of the p-value for the colocalisation.
  \item{\code{pValueExponent}:} \emph{Integer vector}. Exponent of the p-value for the colocalisation.
  \item{\code{numberColocalisingVariants}:} \emph{Integer vector}. Number of colocalising variants.
  \item{\code{colocalisationMethod}:} \emph{Character vector}. Method used for colocalisation analysis.
  \item{\code{h3}:} \emph{Numeric vector}. H3 value associated with the colocalisation.
  \item{\code{h4}:} \emph{Numeric vector}. H4 value associated with the colocalisation.
  \item{\code{clpp}:} \emph{Numeric vector}. Colocalisation posterior probability.
  \item{\code{betaRatioSignAverage}:} \emph{Numeric vector}. Average sign of the beta ratio.
}
}
\description{
This function retrieves colocalisation data for a specific study locus from a GWAS study with other GWAS studies.
It returns a data frame of the studies that colocalise with the input study locus,
including details on the study, reported trait, index variant, and calculated colocalisation method outputs.
}
\examples{
\dontrun{
colocalisation_data <- gwasColocalisation(study_locus_id = "5a86bfd40d2ebecf6ce97bbe8a737512",
 size = 500, index = 0)
}
}
\references{
Giambartolomei, Claudia et al. “Bayesian test for colocalisation between pairs of genetic association studies using summary statistics.” PLoS genetics vol. 10,5 e1004383. 15 May. 2014, doi:10.1371/journal.pgen.1004383
}
