% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binarization.R
\encoding{UTF-8}
\name{binarization}
\alias{binarization}
\title{Constructs the binarized time series associated with a given
ordinal time series}
\usage{
binarization(series, states)
}
\arguments{
\item{series}{An OTS (numerical vector with integers).}

\item{states}{A numeric vector containing the corresponding
states.}
}
\value{
The binarized time series.
}
\description{
\code{binarization} constructs the binarized time series associated with a given
ordinal time series.
}
\details{
Given an OTS of length \eqn{T} with range \eqn{\mathcal{S}=\{s_0, s_1, s_2, \ldots, s_n\}} (\eqn{s_0 < s_1 < s_2 < \ldots < s_n}),
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function
constructs the binarized time series, which is defined as
\eqn{\overline{\boldsymbol Y}_t=\{\overline{\boldsymbol Y}_1, \ldots, \overline{\boldsymbol Y}_T\}},
with \eqn{\overline{\boldsymbol Y}_k=(\overline{Y}_{k,0}, \overline{Y}_{k,1},\ldots, \overline{Y}_{k,n})^\top}
such that \eqn{\overline{Y}_{k,i}=1} if \eqn{\overline{X}_k=s_i} (\eqn{k=1,\ldots,T,
, i=0,\ldots,n}). The binarized series is constructed in the form of a matrix
whose rows represent time observations and whose columns represent the
states in the original series.
}
\examples{
binarized_series <- binarization(AustrianWages$data[[100]],
states = 0 : 5) # Constructing the binarized
# time series for one OTS in dataset AustrianWages
}
\references{
{

  \insertRef{weiss2018introduction}{otsfeatures}
  \insertRef{lopez2023hard}{otsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
