% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c_conditional_probabilities.R
\encoding{UTF-8}
\name{c_conditional_probabilities}
\alias{c_conditional_probabilities}
\title{Computes the cumulative conditional probabilities of an ordinal time series}
\usage{
c_conditional_probabilities(series, lag = 1, states)
}
\arguments{
\item{series}{An OTS.}

\item{lag}{The considered lag (default is 1).}

\item{states}{A numerical vector containing the corresponding
states.}
}
\value{
A matrix with the conditional probabilities.
}
\description{
\code{c_conditional_probabilities} returns a matrix with the cumulative conditional
probabilities of an ordinal time series
}
\details{
Given an OTS of length \eqn{T} with range \eqn{\mathcal{S}=\{s_0, s_1, s_2, \ldots, s_n\}} (\eqn{s_0 < s_1 < s_2 < \ldots < s_n}),
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the
matrix \eqn{\widehat{\boldsymbol F}^c(l) = \big(\widehat{f}^c_{i-1j-1}(l)\big)_{1 \le i, j \le n}},
with \eqn{\widehat{f}^c_{ij}(l)=\frac{TN_{ij}(l)}{(T-l)N_i}}, where
\eqn{N_i} is the number of elements less one or equal to \eqn{s_i} in the realization \eqn{\overline{X}_t} and \eqn{N_{ij}(l)} is the number
of pairs \eqn{(\overline{X}_t, \overline{X}_{t-l})} in the realization \eqn{\overline{X}_t}
such that \eqn{\overline{X}_t \le s_i} and \eqn{\overline{X}_{t-l} \le s_j}.
}
\examples{
matrix_ccp <- c_conditional_probabilities(series = AustrianWages$data[[100]],
states = 0 : 5) # Computing the matrix of
# cumulative conditional probabilities for one series in dataset AustrianWages
}
\references{
{

  \insertRef{weiss2019distance}{otsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
