% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_VLE.R
\name{convert_VLE}
\alias{convert_VLE}
\title{Converts the VLE data format}
\usage{
convert_VLE(
  data,
  conversion = c("binary", "standardise1", "standardise2", "logarithmic")
)
}
\arguments{
\item{data}{VLE data set to be converted. The VLE data set should consist of student_id
as the first column followed by total view counts per time period/activity in
each of the remaining columns.}

\item{conversion}{type of conversion to implement, either \code{"binary"}, \code{"standardise1"} (standardises each variable individually by using the scale function),
\code{"standardise2"} (performs global standardisation of the data set),
or \code{"logarithmic"} (where 1 is added first to the data).}
}
\value{
Two tibbles are returned: 1) original_data, and 2) converted_data.
}
\description{
Converts the data format of the Virtual Learning Environment (VLE) data set from total view counts to binary, standardised or logarithmic view count data.
}
\section{original_data tibble}{

A tibble of the original data inputted into the function.
}

\section{converted_data tibble}{

A tibble where all columns, except the first column, have been changed from total view counts
to either binary, standardised, globally standardised or logarithmic view count data.
}

\examples{
VLE_data = dataset_VLE_activity(example_data = TRUE)$resource_data
convert_VLE(VLE_data, conversion = "standardise1")

VLE_data = dataset_VLE_time(example_data = TRUE)$weekly_data
convert_VLE(VLE_data, conversion = "logarithmic")
}
\seealso{
\code{\link[=dataset_VLE_time]{dataset_VLE_time()}} or \code{\link[=dataset_VLE_activity]{dataset_VLE_activity()}} for obtaining the VLE data set needed for the input data.
}
