% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backtrack.R
\name{plot_backtrack}
\alias{plot_backtrack}
\title{Plot the dissimilarity curve showing the backtrack solution.}
\usage{
plot_backtrack(ombc_out, max_total_rise = 0.1, max_step_rise = 0.05)
}
\arguments{
\item{ombc_out}{An \code{"outliermbc_gmm"} or \code{"outliermbc_lcwm"} object, i.e. an
output from \code{ombc_gmm} or \code{ombc_lcwm}.}

\item{max_total_rise}{Upper limit for the cumulative increase, as a
proportion of the global minimum dissimilarity, from
all backward steps.}

\item{max_step_rise}{Upper limit for the increase, as a proportion of the
global minimum dissimilarity, from each backward step.}
}
\value{
\code{plot_backtrack} returns a ggplot of the rescaled dissimilarity curve showing
the minimum solution and the backtrack solutions.
}
\description{
Plots a rescaled dissimilarity curve where the dissimilarity values (y axis)
have been divided by their minimum so that the rescaled minimum is at 1.
Vertical lines mark the minimum and backtrack solutions.
}
