% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_lcwm.R
\name{test_outlier_ombc}
\alias{test_outlier_ombc}
\title{Check if a new sample satisfies the outlier criteria.}
\usage{
test_outlier_ombc(
  outlier_type,
  mu,
  sigma,
  beta,
  error_sd,
  x_sample,
  y_sample,
  prob_range,
  g
)
}
\arguments{
\item{outlier_type}{Character string governing whether the outliers are
outlying with respect to the explanatory variable only
(\code{"x_only"}), the response variable only (\code{"y_only"}), or
both (\code{"x_and_y"}). \code{"x_and_y"} is the default value.}

\item{mu}{List of component mean vectors.}

\item{sigma}{List of component covariance matrices.}

\item{beta}{List of component regression coefficient vectors.}

\item{error_sd}{Vector of component regression error standard deivations.}

\item{x_sample}{New covariate sample.}

\item{y_sample}{New response sample.}

\item{prob_range}{Values for uniform sample rejection.}

\item{g}{Component number.}
}
\value{
\code{test_outlier_ombc} returns a vector consisting of a logical value indicating
whether the new sample satisfies the outlier checks, and a numeric value
giving the probability of sampling a more extreme point from component \code{g}.
}
\description{
This function checks whether a given sample is an acceptable outlier with
respect to \code{prob_range} and also computes the probability of sampling a more
extreme point from component \code{g}.
}
