% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_inspection.R
\name{do_discount_check}
\alias{do_discount_check}
\title{Perform discounted and undiscounted results check}
\usage{
do_discount_check(df, v_outcomes = NULL, v_outcomes_d = NULL)
}
\arguments{
\item{df}{a dataframe.}

\item{v_outcomes}{(a vector of) character. Name of the variables containing undiscounted outcomes of the model.}

\item{v_outcomes_d}{(a vector of) character. Name of the variables containing discounted outcomes of the model.}
}
\value{
A matrix.
}
\description{
This function performs multiple checks on user-defined columns.
}
\details{
The variables contained in `v_outcomes` and `v_outcomes_d` should be in the same order.
}
\examples{
# Checking whether discounted QALYs are lower than undiscounted QALYs using the example data
\donttest{do_discount_check(df = df_pa,
                  v_outcomes = "t_qaly_comp",
                  v_outcomes_d = "t_qaly_d_comp")
                  }
}
