% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_costeffectiveness.R
\name{calculate_nb}
\alias{calculate_nb}
\title{Calculate NMB and NHB for two strategies.}
\usage{
calculate_nb(df, e_int, e_comp, c_int, c_comp, wtp)
}
\arguments{
\item{df}{a dataframe.}

\item{e_int}{character. Name of variable of the dataframe containing total effects of the intervention strategy.}

\item{e_comp}{character. Name of variable of the dataframe containing total effects of the comparator strategy.}

\item{c_int}{character. Name of variable of the dataframe containing total costs of the intervention strategy.}

\item{c_comp}{character. Name of variable of the dataframe containing total costs of the comparator strategy.}

\item{wtp}{numeric. Willingness-to-pay thresholds to use for NMB and NHB calculations.}
}
\value{
A dataframe containing the original data and the following variables:
\itemize{
  \item NMB_int = Net monetary benefit of the intervention
  \item NMB_comp = Net monetary benefit of the comparator
  \item iNMB = Incremental net monetary benefit of the intervention versus the comparator
  \item NHB_int = Net health benefit of the intervention
  \item NHB_comp = Net health benefit of the comparator
  \item iNHB = Net health benefit of the intervention versus the comparator
}
}
\description{
This function calculates the Net Monetary Benefits (NMB) and Net Health Benefits (NHB) for each strategy and the incremental NMB and NHB.
}
\examples{
# Calculate NB's at a willingness-to-pay threshold of 80000 per unit of effects
data("df_pa")
calculate_nb(df = df_pa,
             e_int = "t_qaly_d_int",
             e_comp = "t_qaly_d_comp",
             c_int = "t_costs_d_int",
             c_comp = "t_costs_d_comp",
             wtp = 80000)
}
