% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist_boxplot.r
\name{hist_boxplot}
\alias{hist_boxplot}
\title{Plot a histogram with a boxplot below}
\usage{
hist_boxplot(
  x,
  freq = TRUE,
  density = FALSE,
  main = NULL,
  xlab = NULL,
  ymax = NULL,
  col.hist = "lightblue",
  col.boxplot = "lightblue",
  ...
)
}
\arguments{
\item{x}{a numeric vector}

\item{freq}{boolean, \code{TRUE} for frequency or \code{FALSE} probability on the y axis}

\item{density}{boolean, \code{TRUE} to plot the estimated density}

\item{main}{character string, main title of the histogram}

\item{xlab}{character string, label of the x axis}

\item{ymax}{numeric value, maximum of the y axis}

\item{col.hist}{color of the histogram}

\item{col.boxplot}{color of the boxplot}

\item{\dots}{other arguments to be passed in \code{hist()}}
}
\value{
None
}
\description{
Plots a histogram with a boxplot below
}
\examples{
par(mfrow=c(1,2))
hist_boxplot(rnorm(100),col.hist="lightblue",col.boxplot="red",freq=TRUE)
hist_boxplot(rnorm(100),col.hist="lightblue",col.boxplot="red",freq=FALSE,density=TRUE)
}
\author{
Hugo Varet
}
