% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2dii.plot.R
\name{recode_metric_trajectory}
\alias{recode_metric_trajectory}
\title{Replicate labels produced with \verb{qplot_*()} functions}
\usage{
recode_metric_trajectory(x)
}
\arguments{
\item{x}{A character vector.}
}
\value{
A character vector.
}
\description{
\itemize{
\item \code{to_title()} converts labels like \code{\link[r2dii.plot:qplot_emission_intensity]{qplot_emission_intensity()}}.
\item \code{recode_metric_trajectory()} converts labels like \code{\link[r2dii.plot:qplot_trajectory]{qplot_trajectory()}}.
\item \code{recode_metric_techmix()} converts labels like \code{\link[r2dii.plot:qplot_techmix]{qplot_techmix()}}.
\item \code{spell_out_technology()} converts technology labels like \code{\link[r2dii.plot:qplot_techmix]{qplot_techmix()}}.
}
}
\examples{
to_title(c("a.string", "another_STRING"))

metric <- c("projected", "corporate_economy", "target_xyz", "else")
recode_metric_trajectory(metric)

recode_metric_techmix(metric)

spell_out_technology(c("gas", "ice", "coalcap", "hdv"))
}
\seealso{
Other plotting functions: 
\code{\link{plot_emission_intensity}()},
\code{\link{plot_techmix}()},
\code{\link{plot_trajectory}()},
\code{\link{prep_emission_intensity}()},
\code{\link{prep_techmix}()},
\code{\link{prep_trajectory}()},
\code{\link{qplot_emission_intensity}()},
\code{\link{qplot_techmix}()},
\code{\link{qplot_trajectory}()},
\code{\link{recode_metric_techmix}()},
\code{\link{scale_colour_r2dii}()},
\code{\link{scale_colour_r2dii_sector}()},
\code{\link{scale_colour_r2dii_tech}()},
\code{\link{scale_fill_r2dii}()},
\code{\link{scale_fill_r2dii_sector}()},
\code{\link{scale_fill_r2dii_tech}()},
\code{\link{spell_out_technology}()},
\code{\link{theme_2dii}()},
\code{\link{to_title}()}
}
\concept{plotting functions}
