% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics_api.R
\name{pa_initialize_oauth}
\alias{pa_initialize_oauth}
\title{Register the Oauth2.0 credentials to the R environment}
\usage{
pa_initialize_oauth(client_id, client_secret)
}
\arguments{
\item{client_id}{client id used to authenticate the HTTP request}

\item{client_secret}{client secret used to authenticate the HTTP request}
}
\value{
No return value, called for side effects
}
\description{
Register the Oauth2.0 credentials to the R environment
}
\details{
initialize_oauth registers the client id and secret to the machine's R environment
All the other functions that rely on authentication will search for the clients id ans secret in
the R environment. Do not share your R environment with others, as they will be able to read your client id and secret.
You can register at \url{https://dataspace.copernicus.eu/news}. Please see this section for how to create your Oauth2.0 client:
\url{https://documentation.dataspace.copernicus.eu/APIs/SentinelHub/Overview/Authentication.html}.
}
\examples{
\dontrun{
pa_initialize_oauth('my-client-id', 'my-client-secret')
}

}
\author{
Caio dos Santos and Fernando Miguez
}
