% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subscriptions.R
\name{paddle_activate_trial_subscription}
\alias{paddle_activate_trial_subscription}
\title{Activate a trialing subscription}
\usage{
paddle_activate_trial_subscription(id)
}
\arguments{
\item{id}{Character. Required. The Paddle subscription ID (e.g. "sub_abc123").}
}
\value{
A list with updated subscription entity and metadata.
}
\description{
Activates a trialing subscription using its ID. Only automatically-collected subscriptions
with status = "trialing" can be activated.
}
\details{
This triggers an immediate charge and recalculates billing dates from activation time.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_paddle_mode("sandbox")
result <- paddle_activate_trial_subscription(id = "sub_123")
\dontshow{\}) # examplesIf}
}
