% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customers.R
\name{paddle_list_customers}
\alias{paddle_list_customers}
\title{Retrieve Paddle Customers}
\usage{
paddle_list_customers(
  email = NULL,
  id = NULL,
  status = NULL,
  after = NULL,
  order_by = NULL,
  per_page = NULL,
  search = NULL
)
}
\arguments{
\item{email}{Vector of email addresses to match exactly. Optional.}

\item{id}{Character vector of Paddle customer IDs. Optional.}

\item{status}{Characte vector of statuses to filter by (`"active"` or `"archived"`). Optional.}

\item{after}{Character. Return entities after the specified Paddle ID when working with paginated endpoints. Optional.}

\item{order_by}{Character. Order results by `"id[ASC]"` or `"id[DESC]"`. Optional.}

\item{per_page}{Integer. Number of results per page (1–200). Optional, defaults to 50.}

\item{search}{Character. Search term (one of `"id"`, `"name"`, `"email"`). Optional.}
}
\value{
A list with customer data and pagination info.
}
\description{
Fetches a paginated list of customers. By default, only active customers are returned.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_paddle_mode("sandbox")
result <- paddle_list_customers()
\dontshow{\}) # examplesIf}
}
