% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discounts.R
\name{paddle_list_discounts}
\alias{paddle_list_discounts}
\title{Retrieve Paddle Discounts}
\usage{
paddle_list_discounts(
  id = NULL,
  code = NULL,
  status = NULL,
  mode = NULL,
  after = NULL,
  order_by = NULL,
  per_page = NULL
)
}
\arguments{
\item{id}{Character vector of discount IDs (e.g., `"dsc_xxx"`). Optional.}

\item{code}{Character vector of discount codes. Optional.}

\item{status}{Character vector of discount statuses (one of `"active"`, `"archived"`). Optional.}

\item{mode}{Character. Filter discounts by mode (one of `"standard"`, `"custom"`). Optional.}

\item{after}{Character. Return entities after the specified Paddle ID (used for pagination). Optional.}

\item{order_by}{Character. Ordering string (e.g., `"id[ASC]"` or `"created_at[DESC]"`). Optional.}

\item{per_page}{Integer. Number of results per page (max 200). Optional, defaults to 50.}
}
\value{
A list containing discount data and pagination metadata.
}
\description{
Fetches a paginated list of discounts from the Paddle API. By default, only active discounts are returned.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_paddle_mode("sandbox")
result <- paddle_list_discounts()
\dontshow{\}) # examplesIf}
}
