% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subscriptions.R
\name{paddle_preview_subscription_update}
\alias{paddle_preview_subscription_update}
\title{Preview an update to a subscription}
\usage{
paddle_preview_subscription_update(
  id,
  customer_id = NULL,
  address_id = NULL,
  business_id = NULL,
  currency_code = NULL,
  next_billed_at = NULL,
  discount = NULL,
  collection_mode = NULL,
  billing_details = NULL,
  items = NULL,
  proration_billing_mode = NULL,
  on_payment_failure = NULL,
  custom_data = NULL,
  scheduled_change = NULL
)
}
\arguments{
\item{id}{Character. Required. Paddle ID of the subscription (e.g. "sub_abc123").}

\item{customer_id}{Character. Optional. Paddle customer ID.}

\item{address_id}{Character. Optional. Paddle address ID.}

\item{business_id}{Character or NULL. Optional.}

\item{currency_code}{Character. Optional. Supported: "USD", "EUR", "GBP" (for manual collection).}

\item{next_billed_at}{Character. Optional. RFC 3339 datetime string.}

\item{discount}{List or NULL. Optional. Must include `id` (string) and `effective_from` (string, must be one of `"immediately"` or `"next_billing_period`), or NULL to remove.}

\item{collection_mode}{Character. Optional. One of: `"automatic"`, `"manual"`.}

\item{billing_details}{List or NULL. Required if `collection_mode` is "manual", NULL if changing collection_mode to automatic. Must include `enable_checkout` (boolean), `purchase_order_number` (string), `payment_terms` (list with `interval` (`day`, `week`, `month` or `year`) and `frequency` (integer)) and optional `additional_information` (string)}

\item{items}{List of item lists. Optional. Each must include `price_id` (string) and `quantity` (numeric). If updating an existing item and not changing the quantity, you may omit quantity.}

\item{proration_billing_mode}{Character. Required when making changes that impact billing. Must be one of:
`"prorated_immediately"`, `"prorated_next_billing_period"`, `"full_immediately"`, `"full_next_billing_period"` and `"do_not_bill"`.}

\item{on_payment_failure}{Character. Optional. Must be one of: `"prevent_change"`, `"allow_change"`.}

\item{custom_data}{Named list or NULL. Optional.}

\item{scheduled_change}{NULL. Set to NULL to remove a scheduled change.}
}
\value{
A list containing subscription preview and transaction impact.
}
\description{
Previews an update to a subscription without applying those changes.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_paddle_mode("sandbox")
result <- paddle_preview_subscription_update(
  id = "sub_123",
  custom_data = list(purpose = "example")
)
\dontshow{\}) # examplesIf}
}
